<?php
/*
	include scripts
*/

 function lubrichem_script_enqueue() {
 	//css
	wp_enqueue_style('bootstrap', get_template_directory_uri().'/css/bootstrap.min.css', array(),'1.0.0', 'all' );
	wp_enqueue_style('customstyle', get_template_directory_uri().'/css/lubrichem.css', array(),'1.0.0', 'all' );
	wp_enqueue_style('animate', get_template_directory_uri().'/css/animate.css', array(),'1.0.0', 'all' );
	// wp_enqueue_style('slider', get_template_directory_uri().'/css/owl.theme.css', array(),'1.0.0', 'all' );
// 	wp_enqueue_style('slider2', get_template_directory_uri().'/css/owl.carousel.css', array(),'1.0.0', 'all' );
// 	wp_enqueue_style('slider2', get_template_directory_uri().'/css/responsive.css', array(),'1.0.0', 'all' );


	
	//js
	wp_enqueue_script('jquery');
	wp_enqueue_script('bootstrapjsmin', get_template_directory_uri().'/js/bootstrap.min.js', array(),'3.3.4', true);
// 	wp_enqueue_script('bootstrapjs', get_template_directory_uri().'/js/bootstrap.js', array(),'3.3.4', true);
	wp_enqueue_script('customjs', get_template_directory_uri().'/js/lubrichem.js', array(),'1.0.0', true);
	// wp_enqueue_script('modernizer', get_template_directory_uri().'/js/modernizr.custom.js', array(),'1.0.0', true);
// 	wp_enqueue_script('smoothscroll', get_template_directory_uri().'/js/SmoothScroll.js', array(),'1.0.0', true);
// 	wp_enqueue_script('isotope', get_template_directory_uri().'/js/jquery.isotope.js', array(),'1.0.0', true);
// 	wp_enqueue_script('carousel', get_template_directory_uri().'/js/owl.carousel.js', array(),'1.0.0', true);
} 


add_action('wp_enqueue_scripts','lubrichem_script_enqueue');

function lubrichem_theme_setup() {
	add_theme_support('menus');
	register_nav_menu('primary','Primary Header Navigation');
	register_nav_menu('secondary','Footer Navigation');
	add_image_size('prod-thumb', 250, 200, array('center','top'));
	add_image_size('featured-prod', 1600, 500, array('center','bottom'));
}


add_action('init', 'lubrichem_theme_setup' );
add_theme_support('custom-background');
add_theme_support( 'custom-logo' );
add_theme_support('custom-header');
add_theme_support('post-thumbnails');
add_theme_support('post-formats', array('aside','image','video'));


/*
	==========================================
	 Sidebar function
	==========================================
*/
function lubrichem_widget_setup() {
	
	register_sidebar(
		array(	
			'name'	=> 'Sidebar',
			'id'	=> 'sidebar-1',
			'class'	=> 'custom',
			'description' => 'Standard Sidebar',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h1 class="widget-title">',
			'after_title'   => '</h1>',
		)
	);
	
}
add_action('widgets_init','lubrichem_widget_setup');
require_once('wp_bootstrap_navwalker.php');

add_action( 'customize_register' , 'my_theme_options' );
function my_theme_options( $wp_customize ) {
    $wp_customize->add_section('mytheme_section_bg_img', array(
            'title'       => __( 'Section ko', 'lubrichem' ),
            'priority'    => 100,
            'capability'  => 'edit_theme_options',
            'description' => __('Select a background image', 'lubrichem'), 
        ) 
    );  

    $wp_customize->add_setting('section_bg_img');

    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'section_bg_img', array(
            'label'    => __( 'Background image', 'lubrichem' ), 
            'section'  => 'mytheme_section_bg_img',
            'settings' => 'section_bg_img',
            'priority' => 10,
        ) 
    ));
}

